<!-- Navbar -->
<nav class="navbar navbar-expand-lg sticky-top">
    <div class="container-fluid p-100">
        <a class="navbar-brand" href="/">
            <img src="<?php echo e(asset('website/assets/images/kydzoologo.webp')); ?>" alt="Logo" class="logo-img">
        </a>

        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav"
                aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>

        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav mx-auto ">
                <li class="nav-item">
                    <a class="nav-link" href="/"><?php echo e(__('lang.Home')); ?></a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('about-us')); ?>"><?php echo e(__('lang.About Us')); ?></a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('courses.index')); ?>"><?php echo e(__('lang.Courses')); ?></a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('books.index')); ?>"><?php echo e(__('lang.Books')); ?></a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('events.index')); ?>"><?php echo e(__('lang.Events')); ?></a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('blogs.index')); ?>"><?php echo e(__('lang.Blog')); ?></a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('consultation.index')); ?>"><?php echo e(__('lang.Book a consultation')); ?></a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('contact.form')); ?>"><?php echo e(__('lang.Contact Us')); ?></a>
                </li>

                <?php if(auth()->guard()->check()): ?>
                    <li class="nav-item nav-mobile">
                        <a class="nav-link" href="<?php echo e(route('profile.index')); ?>"><?php echo e(__('lang.My Profile')); ?></a>
                    </li>

                    <li class="nav-item nav-mobile">
                        <div class="nav-link">
                            <form action="<?php echo e(route('logout')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="logout-btn">
                                    <?php echo e(__('lang.Logout')); ?>

                                </button>
                            </form>
                        </div>
                    </li>
                <?php else: ?>
                    <li class="nav-item nav-mobile">
                        <a class="nav-link" href="<?php echo e(route('login.show')); ?>"><?php echo e(__('lang.Login')); ?></a>
                    </li>

                    <li class="nav-item nav-mobile">
                        <a class="nav-link" href="<?php echo e(route('register.show')); ?>"><?php echo e(__('lang.signup')); ?></a>
                    </li>
                <?php endif; ?>

            </ul>

            <div class="ml-auto d-flex align-items-center">
                <!-- User Icon with Dropdown -->
                <div class="dropdown">
                    <a href="/" class="user-icon" id="userDropdown" role="button" data-bs-toggle="dropdown"
                       aria-expanded="false">
                        <img src="<?php echo e(asset('website/assets/images/user-icon.svg')); ?>" alt="User Icon"
                             class="user-icon-img">
                    </a>

                    <!-- Dropdown Menu -->
                    <ul class="dropdown-menu dropdown-menu-end custom-dropdown mt-5" aria-labelledby="userDropdown">
                        <?php if(auth()->guard()->check()): ?>
                            <li><a class="dropdown-item" href="<?php echo e(route("profile.index")); ?>"><i
                                        class="fas fa-user"></i> <?php echo e(__('lang.My Profile')); ?></a></li>
                            <li>
                                <form action="<?php echo e(route('logout')); ?>" method="POST" style="display: inline;">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="dropdown-item">
                                        <i class="fas fa-sign-out-alt"></i> <?php echo e(__('lang.Logout')); ?>

                                    </button>
                                </form>
                            </li>
                        <?php else: ?>
                            <li><a class="dropdown-item" href="<?php echo e(route('login.show')); ?>"><i
                                        class="fas fa-sign-in-alt mx-3"></i> <?php echo e(__('lang.Login')); ?></a></li>
                            <li><a class="dropdown-item" href="<?php echo e(route('register.show')); ?>"><i
                                        class="fas fa-sign-in-alt  mx-3"></i> <?php echo e(__('lang.signup')); ?></a></li>
                        <?php endif; ?>
                    </ul>
                </div>

                <!-- Language Selector -->
                <div class="language-selector">
                    <div class="dropdown">
                        <!-- Button with Current Locale -->
                        <button class="btn btn-secondary dropdown-toggle" type="button" id="languageDropdown"
                                data-bs-toggle="dropdown" aria-expanded="false">
                            <?php echo e(LaravelLocalization::getCurrentLocaleNative()); ?>

                        </button>
                        <ul class="dropdown-menu" aria-labelledby="languageDropdown">
                            <?php $__currentLoopData = LaravelLocalization::getSupportedLocales(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $localeCode => $properties): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <a class="dropdown-item" rel="alternate" hreflang="<?php echo e($localeCode); ?>"
                                       href="<?php echo e(LaravelLocalization::getLocalizedURL($localeCode, null, [], true)); ?>">
                                        <?php echo e($properties['native']); ?>

                                    </a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>

            </div>
        </div>
    </div>
</nav>
<?php /**PATH /home/intcoredev/public_html/kydzoo.intcore.dev/resources/views/layouts/navbar.blade.php ENDPATH**/ ?>