<?php $__env->startSection('content'); ?>

    <!-- Header Section -->
    <?php echo $__env->make('website.profile.header', ['header_name' =>   __('lang.my_account') ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <section class="profile-orders">
        <div class="container-fluid p-100">
            <div class="row">
                <!-- Sidebar -->
                <?php echo $__env->make('website.profile.slider', ['page'=> "Purchased"], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


                <!-- Main Content -->
                <div class="col-md-10">
                    <!-- Header Tabs -->
                    <ul class="nav header-tabs">
                        <div class="col-md-3">
                            <li class="nav-item">
                                <a class="nav-link <?php echo e(request('search') == 'all' ? 'active' : ''); ?>" href="<?php echo e(route('profile.orders', ['search' => 'all'])); ?>" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                    <?php echo e(__('lang.all')); ?>

                                </a>
                            </li>
                        </div>
                        <div class="col-md-3">
                            <li class="nav-item">
                                <a class="nav-link <?php echo e(request('search') == 'Event' ? 'active' : ''); ?>" href="<?php echo e(route('profile.orders', ['search' => 'Event'])); ?>" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                    <?php echo e(__('lang.Events')); ?>

                                </a>
                            </li>
                        </div>
                        <div class="col-md-2">
                            <li class="nav-item">
                                <a class="nav-link <?php echo e(request('search') == 'Book' ? 'active' : ''); ?>" href="<?php echo e(route('profile.orders', ['search' => 'Book'])); ?>" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                    <?php echo e(__('lang.ebooks')); ?>

                                </a>
                            </li>
                        </div>
                        <div class="col-md-2">
                            <li class="nav-item">
                                <a class="nav-link <?php echo e(request('search') == 'Course' ? 'active' : ''); ?>" href="<?php echo e(route('profile.orders', ['search' => 'Course'])); ?>" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                    <?php echo e(__('lang.courses')); ?>

                                </a>
                            </li>
                        </div>
                    </ul>


                    <!-- Purchased Items List -->
                    <div class="tab-content">
                        <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <div class="item-row">
                            <div class="col-md-3">
                                <img src="<?php echo e($order->productable?->getFirstMediaUrl(\App\Enums\Media\MediaCollection::getImageByProductType($order->productable_type))); ?>" alt="E-Book Image" class="item-img-order"data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                            </div>
                            <div class="col-md-3 item-details"data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                <h2><?php echo e(getColumn($order->productable, "name")); ?></h2>
                            </div>
                            <div class="col-md-2 item-category"data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                <h4> <?php echo e(\App\Enums\Product\ProductType::getProductType($order->productable_type)); ?></h4>
                            </div>
                            <div class="col-md-2 date-orders"data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                <p ><?php echo e(\Carbon\Carbon::parse($order->created_at)->format('F d, Y')); ?></p>
                            </div>
                            <div class="col-md-2 ">

                               <?php if(\App\Enums\Product\ProductType::getProductType($order->productable_type) == "E-BOOK"): ?>
                                    <a href="<?php echo e($order->productable?->getFirstMediaUrl(\App\Enums\Media\MediaCollection::BOOK_FILE->value)); ?>" download="" class="btn view-details-orders"data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">View details</a>

                                <?php endif; ?>

                                <?php if(\App\Enums\Product\ProductType::getProductType($order->productable_type) == "COURSE"): ?>
                                 <a href="  <?php echo e(route('courses.show', ['slug' => $order->productable->slug])); ?>" class="btn view-details-orders"data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">View details</a>

                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/intcoredev/public_html/kydzoo.intcore.dev/resources/views/website/profile/profile-orders.blade.php ENDPATH**/ ?>