<?php use App\Enums\Media\MediaCollection; ?>

<?php $__env->startSection('page-name', __('lang.home')); ?>

<?php $__env->startSection('content'); ?>
    <!--Hero Section-->
    <section class="hero-section" style="background-image: url('<?php echo e($cover?->getFirstMediaUrl( app()->getLocale() == "ar" ? "home_cover_image_arabic" : "home_cover_image_english" )); ?> ');">
        <div class="container-fluid p-80">
            <div class="content-wrapper">
                <p class="word-experts" data-aos="fade-up" data-aos-duration="800" data-aos-offset="10">
                    <?php echo e(getColumn($cover, 'title')); ?>

                </p>
                <h1 class="hero-title" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                    <?php echo getColumn($cover, 'description'); ?>

                </h1>
                <div class="button-heros">
                    <a href="<?php echo e(route('register.show')); ?>" class="become-member" data-aos="fade-up"
                       data-aos-duration="1200"
                       data-aos-offset="10"><?php echo e(__("lang.become_member")); ?></a>
                    <a href="<?php echo e(route('courses.index')); ?>" class="explore-courses" data-aos="fade-up"
                       data-aos-duration="1200"
                       data-aos-offset="10"><?php echo e(__("lang.explore_courses")); ?></a>
                </div>
            </div>
        </div>
    </section>

    <section class="container-fluid p-100 image-slogan-section">
        <div class="image-slogan">
            <img src="<?php echo e($slogan->getFirstMediaUrl( app()->getLocale() == "ar" ? MediaCollection::SLOGAN_HOME_IMAGE_ARABIC->value : MediaCollection::SLOGAN_HOME_IMAGE_ENGLISH->value)); ?>" alt="Creative Design" class="creative-image">
        </div>
    </section>

    <!--Book Release-->
    <section class="book-release-section py-5">
        <div class="container-fluid p-100">
            <div class="row d-flex align-items-center" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                <!-- Book Image Container -->
                <div class="col-md-4 text-center mb-4 mb-md-0 book-home p-5">
                    <img src="<?php echo e($announcement->getFirstMediaUrl( app()->getLocale() == "ar" ? MediaCollection::ANNOUNCEMENT_IMAGE_ARABIC->value : MediaCollection::ANNOUNCEMENT_IMAGE_ENGLISH->value)); ?>"
                         alt="<?php echo e(__("lang.book_release_title")); ?>"
                         class="book-image">
                </div>
                <!-- Content Container -->
                <div class="col-md-8 text-left text-md-left">
                    <h3 class="new-release-text"><?php echo e(getColumn($announcement, 'title')); ?></h3>
                    <p class="sub-text-release"><?php echo getColumn($announcement, 'description'); ?></p>
                    <div class="button-container">
                        <a href="<?php echo e($announcement->announcement_url); ?>" class="btn btn-custom-primary">
                            <?php echo e(__("lang.get_your_copy_now")); ?>

                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

     <!--Courses Slider -->
    <div class="CoursesBg">
        <div class="container-fluid p-100">
            <div class="events-header mb-4">
                <div class="prev-events-arrow">
                    <img src="<?php echo e(asset('website/assets/images/chervonleft-black.webp')); ?>" alt="Previous">
                </div>
                <div class="header-content-events">
                    <h2 data-aos="fade-up" data-aos-duration="1000"
                        data-aos-offset="10"><?php echo e(__("lang.courses_header")); ?></h2>
                    <p data-aos="fade-up" data-aos-duration="1000"
                       data-aos-offset="10"><?php echo e(__("lang.courses_subtitle")); ?></p>
                </div>
                <div class="next-events-arrow">
                    <img src="<?php echo e(asset('website/assets/images/chervon-right-black.webp')); ?>" alt="Next">
                </div>
            </div>

            <div class="courses-slider row">
                     <?php $__currentLoopData = $isFeaturedCourses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $isFeaturedCourse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-12 col-md-12 mb-2" data-aos="fade-up" data-aos-duration="500" data-aos-offset="10">
                    <div class="card-courses" >
                        <div class="badge"><?php echo e($isFeaturedCourse->is_new ? __("lang.new") : ""); ?></div>
                        <a href="<?php echo e(route('courses.show', ['slug' => $isFeaturedCourse->slug])); ?>" >
                            <img
                                src="<?php echo e($isFeaturedCourse->getFirstMediaUrl( app()->getLocale() == 'ar' ? MediaCollection::HOME_COURSE_IMAGE_ARABIC->value : MediaCollection::HOME_COURSE_IMAGE_ENGLISH->value)); ?>"
                                alt="<?php echo e($isFeaturedCourse->name_en); ?>">
                        </a>

                        <h3>
                            <a href="<?php echo e(route('courses.show', ['slug' => $isFeaturedCourse->slug])); ?>" ><?php echo getColumn($isFeaturedCourse, 'short_description'); ?> </a>
                        </h3>
                         <div class="buy-now-prices d-flex align-items-center my-4" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                            <?php if( $isFeaturedCourse->sale_price): ?>
                                <h5 class="original-price mx-2 text-muted text-decoration-line-through"><span>$</span><?php echo e($isFeaturedCourse->price); ?></h5>
                                <h5 class="discounted-price"><span>$</span><?php echo e($isFeaturedCourse->sale_price); ?></h5>
                            <?php else: ?>
                                <h5 class="discounted-price"><span>$</span><?php echo e($isFeaturedCourse->price); ?></h5>

                            <?php endif; ?>
                         </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div class="d-flex justify-content-center">
                <a href="<?php echo e(route('courses.index')); ?>" class="view-all-courses"><?php echo e(__("lang.view_all_courses")); ?></a>
            </div>
        </div>
    </div>

    <!-- OurBooks Slider -->
    <div class="container-fluid p-100">
        <div class="OurBooksSection">
            <!-- Title Section -->
            <div class="OurBooksTitle text-center mb-4">
                <h2><?php echo e(__("lang.our_books")); ?></h2>
            </div>
            <!-- Slider Content -->
            <div class="OurBooks-slider-container d-flex justify-content-center align-items-center position-relative">
                <div class="prev-arrow-books position-absolute">
                    <img src="<?php echo e(asset('website/assets/images/chervon-left-books.svg')); ?>" alt="Previous"/>
                </div>

                <div class="OurBooks-slider mb-1">
                    <?php $__currentLoopData = $isFeaturedBooks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $isFeaturedBook): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="slide-item" data-aos="fade-up" data-aos-duration="600" data-aos-offset="10">
                            <a href="<?php echo e(route('books.show', ['slug' => $isFeaturedBook->slug])); ?>" >
                            <img
                                src="<?php echo e($isFeaturedBook->getFirstMediaUrl( app()->getLocale() == 'ar' ? MediaCollection::BOOK_IMAGE_ARABIC->value : MediaCollection::BOOK_IMAGE_ENGLISH->value)); ?>"
                                alt="<?php echo e(getColumn($isFeaturedBook, 'name')); ?>" class="OurBooksSlide-img"/>
                            </a>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="next-arrow-books position-absolute">
                    <img src="<?php echo e(asset('website/assets/images/chervon-right-books.svg')); ?>" alt="Next"/>
                </div>
            </div>
            <div class="d-flex justify-content-center mb-3">
                <a href="<?php echo e(route('books.index')); ?>" class="view-all-books"><?php echo e(__("lang.view_all_books")); ?></a>
                <div class="custom-dots"></div>
            </div>
        </div>
    </div>

    <!-- Event Slider -->
    <div class="container-fluid p-100">
        <div class="events-header mt-5">
            <div class="prev-events-arrow">
                <img src="<?php echo e(asset('website/assets/images/chervonleft-black.webp')); ?>" alt="Previous">
            </div>
            <div class="header-content-events">
                <h2 data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10"><?php echo e(__("lang.events_header")); ?></h2>
                <p data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10"><?php echo e(__("lang.events_subtitle")); ?></p>
            </div>
            <div class="next-events-arrow">
                <img src="<?php echo e(asset('website/assets/images/chervon-right-black.webp')); ?>" alt="Next">
            </div>
        </div>

        <div class="slider-container">
            <div class="events-slider">
                <?php $__currentLoopData = $isFeaturedEvents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $isFeaturedEvent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="event-card" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                        <a href="<?php echo e(route('events.show', ['slug' => $isFeaturedEvent->slug])); ?>" >

                        <img src="<?php echo e($isFeaturedEvent->getFirstMediaUrl(MediaCollection::EVENT_IMAGE->value)); ?>"
                             alt="<?php echo e($isFeaturedEvent->name_en); ?>">
                        </a>
                        <div class="content-event-slider">
                            <div class="overlay-event-slider"></div>
                            <a href="<?php echo e(route('events.show', ['slug' => $isFeaturedEvent->slug])); ?>" > <h3>   <?php echo e(getColumn($isFeaturedEvent, 'name')); ?></h3></a>
                            <a href="<?php echo e(route('events.show', ['slug' => $isFeaturedEvent->slug])); ?>" >  <p>  <?php echo getColumn($isFeaturedEvent, 'description'); ?></p> </a>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <div class="d-flex justify-content-center mt-5">
                <a href="<?php echo e(route('events.index')); ?>" class="view-our-events"><?php echo e(__("lang.view_our_events")); ?></a>
            </div>
        </div>
    </div>


    <!-- Video Section -->
    <section class="container-fluid p-100">
        <div class="video-section" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
            <div class="video-container">
                <div class="video-overlay"
                     style="background-image: url('<?php echo e($youtube?->getFirstMediaUrl('home')); ?>'); background-size: cover"
                     data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                    <div class="play-button" onclick="openVideoModal( '')">
                        <img src="<?php echo e(asset('website/assets/images/vedio-icon.webp')); ?>" alt="Play Button">
                    </div>
                </div>
            </div>
            <div class="description-vedio">
                <p><?php echo e(__('lang.video_description_about')); ?></p>
                <div class="d-flex justify-content-center mt-5">
                    <a href="<?php echo e($youtube?->youtube_channel_url); ?>"
                       class="join-youtube-channel" target="_blank"><?php echo e(__('lang.join_youtube_channel')); ?></a>
                </div>
            </div>
        </div>
    </section>
    <!-- Video Modal -->
<div id="videoModal" class="modal">
            <div class="modal-content">
            <span class="close" onclick="closeVideoModal()">&times;</span>
                          <iframe id="videoFrame" src="" frameborder="0" allowfullscreen hidden></iframe>

                          <?php echo $youtube?->youtube_video_url; ?>


        </div>
    </div>


    <!--Profile Section-->
    <section class="about-kydzoo">
        <div class="container-fluid p-100">
            <div class="about-section">
                <h2 data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10"><?php echo e(__('lang.About')); ?>

                    <span><?php echo e(__("lang.Kydzzo")); ?></span></h2>
                <p data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                    <?php echo getColumn($about, 'description'); ?>

                </p>
            </div>
        </div>
    </section>

    <!-- Profile Section -->
    <div class="profile-section">
        <img src="<?php echo e($doctor->getFirstMediaUrl('home')); ?>" alt="<?php echo e(__('lang.profile_name')); ?>"
             data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
        <h4 data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10"><?php echo e(getColumn($doctor, 'title')); ?></h4>
        <p data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10"><?php echo getColumn($doctor, 'description'); ?></p>
    </div>

    <!-- Benefits Section Wrapper -->
    <div class="benefits-wrapper">
        <div class="container-fluid p-100">
            <div class="benefits-section">
                <div class="row">
                    <div class="col-6 col-md-3 benefit-item">
                        <img src="<?php echo e(asset('website/assets/images/smileys.webp')); ?>"
                             alt="<?php echo e(__('lang.benefit_1_title')); ?>" data-aos="fade-up" data-aos-duration="1000"
                             data-aos-offset="10">
                        <p data-aos="fade-up" data-aos-duration="1000"
                           data-aos-offset="10"><?php echo e(__("lang.benefit_1_title")); ?></p>
                        <p data-aos="fade-up" data-aos-duration="1000"
                           data-aos-offset="10"><?php echo e(__("lang.benefit_1_description")); ?></p>
                    </div>
                    <div class="col-6 col-md-3 benefit-item">
                        <img src="<?php echo e(asset('website/assets/images/book.webp')); ?>" alt="<?php echo e(__('lang.benefit_2_title')); ?>"
                             data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                        <p data-aos="fade-up" data-aos-duration="1000"
                           data-aos-offset="10"><?php echo e(__("lang.benefit_2_title")); ?></p>
                        <p data-aos="fade-up" data-aos-duration="1000"
                           data-aos-offset="10"><?php echo e(__("lang.benefit_2_description")); ?></p>
                    </div>
                    <div class="col-6 col-md-3 benefit-item">
                        <img src="<?php echo e(asset('website/assets/images/lovely.webp')); ?>"
                             alt="<?php echo e(__('lang.benefit_3_title')); ?>" data-aos="fade-up" data-aos-duration="1000"
                             data-aos-offset="10">
                        <p data-aos="fade-up" data-aos-duration="1000"
                           data-aos-offset="10"><?php echo e(__("lang.benefit_3_title")); ?></p>
                        <p data-aos="fade-up" data-aos-duration="1000"
                           data-aos-offset="10"><?php echo e(__("lang.benefit_3_description")); ?></p>
                    </div>
                    <div class="col-6 col-md-3 benefit-item">
                        <img src="<?php echo e(asset('website/assets/images/airdrop.webp')); ?>"
                             alt="<?php echo e(__('lang.benefit_4_title')); ?>" data-aos="fade-up" data-aos-duration="1000"
                             data-aos-offset="10">
                        <p data-aos="fade-up" data-aos-duration="1000"
                           data-aos-offset="10"><?php echo e(__("lang.benefit_4_title")); ?></p>
                        <p data-aos="fade-up" data-aos-duration="1000"
                           data-aos-offset="10"><?php echo e(__("lang.benefit_4_description")); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!--Customer Love-->
    <div class="customer-love">
        <div class="container-fluid p-100">
            <div class="events-header mb-2">
                <div class="prev-events-arrow">
                    <img src="<?php echo e(asset('website/assets/images/chervonleft-black.webp')); ?>" alt="Previous">
                </div>
                <div class="header-content-events mt-3">
                    <h2 data-aos="fade-up" data-aos-duration="1000"
                        data-aos-offset="10"><?php echo e(__("lang.customer_love_title")); ?></h2>
                </div>
                <div class="next-events-arrow">
                    <img src="<?php echo e(asset('website/assets/images/chervon-right-black.webp')); ?>" alt="Next">
                </div>
            </div>

            <div class="CustomerLove-slider">
                <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="CustomerLove-card" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                        <!-- Use the testimonial's image URL if available, otherwise, provide a default image -->
                        <img src="<?php echo e($testimonial->getFirstMediaUrl(MediaCollection::TESTIMONIAL_IMAGE->value)); ?>"
                             alt="<?php echo e(getColumn($testimonial, 'name')); ?>">
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>

    <!--Blog Section-->
    <div class="blog-section">
        <div class="container-fluid p-100">
            <div class="row">
                <!-- Left Side: Blog Info and Button -->
                <div class="col-md-4 blog-header">
                    <h2 data-aos="fade-up" data-aos-duration="1000"
                        data-aos-offset="10"><?php echo e(__("lang.blog_section_title")); ?></h2>
                    <p data-aos="fade-up" data-aos-duration="1000"
                       data-aos-offset="10"><?php echo e(__("lang.blog_section_description")); ?></p>
                    <a href="<?php echo e(route('blogs.index')); ?>" class="btn btn-seemore" data-aos="fade-up"
                       data-aos-duration="1000" data-aos-offset="10"><?php echo e(__("lang.blog_section_button")); ?></a>
                </div>

                <!-- Loop through blogs -->
                <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-4 d-flex flex-column align-items-left">
                        <!-- Blog Image -->
                        <a href="<?php echo e(route('blogs.show', ['slug' => $blog->slug])); ?>">
                        <img src="<?php echo e($blog->getFirstMediaUrl(app()->getLocale() == 'ar' ? MediaCollection::BLOG_IMAGE_ARABIC->value : MediaCollection::BLOG_IMAGE_ENGLISH->value)); ?>"
                             alt="<?php echo e($blog->title_en); ?>" class="img-fluid blog-image" data-aos="fade-up"
                             data-aos-duration="1000" data-aos-offset="10">
                        </a>
                        <!-- Blog Title -->
                        <a href="<?php echo e(route('blogs.show', ['slug' => $blog->slug])); ?>">
                        <h3 class="blog-title-img" data-aos="fade-up" data-aos-duration="1000"
                            data-aos-offset="10"><?php echo e(getColumn($blog, 'title')); ?></h3>
                        </a>
                        <!-- Blog Date -->
                        <p class="blog-date-img" data-aos="fade-up" data-aos-duration="1000"
                           data-aos-offset="10"><?php echo e($blog->created_at->format('F d, Y')); ?></p>
                        <!-- Blog Read More Link-->
                        <a href="<?php echo e(route('blogs.show', ['slug' => $blog->slug])); ?>" class="blog-read-more" data-aos="fade-up" data-aos-duration="1000"
                           data-aos-offset="10">
                            <?php echo app('translator')->get('lang.Read More »'); ?>
                        </a>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/intcoredev/public_html/kydzoo.intcore.dev/resources/views/website/home.blade.php ENDPATH**/ ?>