@extends('layouts.master')
@section('content')

    <!-- Header Section -->
    @include('website.profile.header', ['header_name' =>   __('lang.my_account') ])


    <section class="profile-orders">
        <div class="container-fluid p-100">
            <div class="row">
                <!-- Sidebar -->
                @include('website.profile.slider', ['page'=> "Purchased"])


                <!-- Main Content -->
                <div class="col-md-10">
                    <!-- Header Tabs -->
                    <ul class="nav header-tabs">
                        <div class="col-md-3">
                            <li class="nav-item">
                                <a class="nav-link {{ request('search') == 'all' ? 'active' : '' }}" href="{{ route('profile.orders', ['search' => 'all']) }}" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                    {{ __('lang.all') }}
                                </a>
                            </li>
                        </div>
                        <div class="col-md-3">
                            <li class="nav-item">
                                <a class="nav-link {{ request('search') == 'Event' ? 'active' : '' }}" href="{{ route('profile.orders', ['search' => 'Event']) }}" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                    {{ __('lang.Events') }}
                                </a>
                            </li>
                        </div>
                        <div class="col-md-2">
                            <li class="nav-item">
                                <a class="nav-link {{ request('search') == 'Book' ? 'active' : '' }}" href="{{ route('profile.orders', ['search' => 'Book']) }}" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                    {{ __('lang.ebooks') }}
                                </a>
                            </li>
                        </div>
                        <div class="col-md-2">
                            <li class="nav-item">
                                <a class="nav-link {{ request('search') == 'Course' ? 'active' : '' }}" href="{{ route('profile.orders', ['search' => 'Course']) }}" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                    {{ __('lang.courses') }}
                                </a>
                            </li>
                        </div>
                    </ul>


                    <!-- Purchased Items List -->
                    <div class="tab-content">
                        @foreach($orders as $order)

                        <div class="item-row">
                            <div class="col-md-3">
                                <img src="{{$order->productable?->getFirstMediaUrl(\App\Enums\Media\MediaCollection::getImageByProductType($order->productable_type))}}" alt="E-Book Image" class="item-img-order"data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                            </div>
                            <div class="col-md-3 item-details"data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                <h2>{{getColumn($order->productable, "name")}}</h2>
                            </div>
                            <div class="col-md-2 item-category"data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                <h4> {{\App\Enums\Product\ProductType::getProductType($order->productable_type)}}</h4>
                            </div>
                            <div class="col-md-2 date-orders"data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                <p >{{\Carbon\Carbon::parse($order->created_at)->format('F d, Y')}}</p>
                            </div>
                            <div class="col-md-2 ">

                               @if(\App\Enums\Product\ProductType::getProductType($order->productable_type) == "E-BOOK")
                                    <a href="{{$order->productable?->getFirstMediaUrl(\App\Enums\Media\MediaCollection::BOOK_FILE->value)}}" download="" class="btn view-details-orders"data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">View details</a>

                                @endif

                                @if(\App\Enums\Product\ProductType::getProductType($order->productable_type) == "COURSE")
                                 <a href="  {{ route('courses.show', ['slug' => $order->productable->slug]) }}" class="btn view-details-orders"data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">View details</a>

                                @endif
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection

