@extends('layouts.master')
@section('content')

    <!-- Header Section -->
    @include('website.profile.header', ['header_name' =>   __('lang.my_account') ])

    <section class="account-detsils-section ">
        <div class="container-fluid p-100 ">
            <div class="row justify-content-center">
                <div class="row">
                    @include('website.profile.slider', ['page' => "Account details"])

                    <div class="col-9 form-Adetails">
                        <form action="{{ route('profile.update') }}" method="POST">
                            @csrf

                            <!-- First Name -->
                            <div class="form-group-Adetails mb-4">
                                <label for="firstName">{{ __('lang.first_name') }} *</label>
                                <input type="text" name="first_name" class="form-control custom-input-accountdet" id="firstName" placeholder="{{ __('lang.first_name') }}" value="{{ old('first_name', $user->first_name) }}" required>
                                @error('first_name')
                                <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Last Name -->
                            <div class="form-group-Adetails mb-4">
                                <label for="lastName">{{ __('lang.last_name') }} *</label>
                                <input type="text" name="last_name" class="form-control custom-input-accountdet" id="lastName" placeholder="{{ __('lang.last_name') }}" value="{{ old('last_name', $user->last_name) }}" required>
                                @error('last_name')
                                <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Display Name -->
                            <div class="form-group-Adetails mb-4">
                                <label for="displayName">{{ __('lang.display_name') }} *</label>
                                <input type="text" name="display_name" class="form-control custom-input-accountdet" id="displayName" placeholder="{{ __('lang.display_name') }}" value="{{ old('display_name', $user->display_name) }}">
                                <small class="display-text-form">{{ __('lang.display_info') }}</small>
                                @error('display_name')
                                <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Email Address -->
                            <div class="form-group-Adetails mb-4">
                                <label for="emailAddress">{{ __('lang.email_address') }} *</label>
                                <input type="email" name="email" class="form-control custom-input-accountdet" id="emailAddress" placeholder="{{ __('lang.email_address') }}" value="{{ old('email', $user->email) }}" required>
                                @error('email')
                                <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Buttons -->
                            <div class="form-group d-flex account-details-buttons">
                                <button type="submit" class="btn submit-btn-Adetails">{{ __('lang.submit') }}</button>
                                <a href="{{route("profile.edit.password")}}" class="btn change-password-btn-Adetails">{{ __('lang.change_password') }}</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
    </section>

@endsection

