@extends('layouts.master')
@section('page-name', $event->slug)

@section('content')
    <!-- Header Section -->
    @include('website.productComponent.show.header-section',[
        'header_breadcrumb' => __("lang.events"),
        'header_subtitle' => __("lang.event_header_subtitle"),
    ])

    <!-- compassionate-section -->
    @include('website.productComponent.show.product-sections',[
             'product' => $event,
             'product_media_collection' => \App\Enums\Media\MediaCollection::EVENT_IMAGE->value,
             'first_section_media_collection' => \App\Enums\Media\MediaCollection::EVENT_SECTION_ONE_IMAGE->value,
             'second_section_media_collection' => \App\Enums\Media\MediaCollection::EVENT_SECTION_TWO_IMAGE->value,
             'third_section_media_collection' => \App\Enums\Media\MediaCollection::EVENT_SECTION_THREE_IMAGE->value,
             'type' => 'event',
    ])



    <!-- interested-section -->
    @include('website.productComponent.show.interested-section',[
             'interested_products' => $interested_events,
             'interested_product_media_collection' => \App\Enums\Media\MediaCollection::EVENT_IMAGE->value
      ])
@endsection


@push("scripts")
    <script type='text/javascript' src='https://platform-api.sharethis.com/js/sharethis.js#property=59ecdf1a95f7b200121c2a4d&product=inline-share-buttons' async='async'></script>
@endpush
