@php use App\Enums\Media\MediaCollection; @endphp
@extends('layouts.master')
@section('page-name', __('lang.Courses'))

@section('content')
    <!-- Header Section -->
    @include('website.productComponent.index.header-section',[
    'header_breadcrumb' => __("lang.Courses"),
    'header_subtitle' => getColumn($coverDescription, 'content'),
    'header_title' => __("lang.Courses"),

])
    <!-- Cards and Catecory Section-->
    <section class="buy-now-section ">
        <div class="container-fluid p-100">
            <div class="row">
                @include('website.productComponent.index.category-box',[
                        'categories' => $categories,
                         'category_filter_route' => "courses.index"

                 ])



                <!-- Right Section for Courses -->
                @include('website.productComponent.index.products-section', [
                     'products' => $courses,
                      'image_collection' => app()->getLocale() == 'ar' ? MediaCollection::LIST_COURSE_IMAGE_ARABIC->value : MediaCollection::LIST_COURSE_IMAGE_ENGLISH->value,
                     'product_route_name' =>'courses.show',
                     'type' =>'courses',

                    ])
            </div>
        </div>
        </div>

    </section>

@endsection
