@php use App\Enums\Media\MediaCollection; @endphp
@php use Carbon\Carbon; @endphp
@extends('layouts.master')
@section('page-name', __('lang.Blog'))

@section('content')
    <!-- Header Section -->
    <section class="header-bg">
        <div class="container-fluid p-100">
            <div class="header-section">
                <div class="overlay"></div>
                <div class="header-content">
                    <p class="small-title" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                        {{ __('lang.home') }}
                        <img
                            src="{{ asset('website/assets/images/smallchervon left.svg') }}"
                            alt="{{ __('lang.arrow') }}"
                            class="breadcrumb-arrow"
                            style="{{ app()->getLocale() === 'ar' ? 'transform: rotate(180deg)' : '' }}">

                        {{ __('lang.blog') }}
                    </p>
                    <h1 class="header-title" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                        {{ __('lang.kyddzo_blog') }}
                    </h1>
                    <p class="header-subtitle" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                        {!! getColumn($coverDescription, 'content') !!}
                    </p>

                    <form method="GET" action="{{ route('blogs.index') }}" class="search-input-container"
                          data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                        <input type="text" name="search" class="form-control search-input-blog"
                               placeholder="{{ __('lang.search') }}" value="{{ request('search') }}">
                        <button type="submit" class="search-button">
                            <img src="{{ asset('website/assets/images/search-icon.svg') }}"
                                 alt="{{ __('lang.search_icon') }}">
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </section>

    <!-- Blog Card Section -->
    <section class="blog-section">
        <div class="container-fluid  p-100">

            <div class="row">
                <div class="col-md-3">
                    <div class="category-section">
                        <h5 class="mb-2 d-flex justify-content-between align-items-center">
                            <span>{{__('lang.Category')}}</span>
                        </h5>

                        <ul class="list-group list-group-flush">
                            <li class="list-group-item">
                                <input class="form-check-input me-2 checkbox-custom" type="checkbox" id="all"
                                       value="all">
                                <label class="form-check-label" for="all">{{__("lang.All")}}</label>
                            </li>

                            <!-- Categories dynamically loaded from the backend -->
                            @foreach($categories as $category)
                                <li class="list-group-item">
                                    <input class="form-check-input me-2 checkbox-custom" type="checkbox"
                                           {{in_array( $category->id, request('categories') ?? []) ? 'checked' : "" }}
                                           id="category-{{ $category->id }}" value="{{ $category->id }}">
                                    <label class="form-check-label"
                                           for="category-{{ $category->id }}">{{ getColumn($category, 'name') }}</label>
                                </li>
                            @endforeach
                        </ul>

                        <button id="filterProducts" class="buy-now-btn aos-init aos-animate mt-3">Filter</button>
                    </div>
                </div>

                <div class="col-md-9">
                    <h5 class="articles-text-blog" data-aos="fade-up" data-aos-duration="1000"
                        data-aos-offset="10"> {{ __('lang.articles_count', ['count' => $blogs->count()]) }}</h5>
                    <div class="row">
                        @foreach($blogs as $blog)
                            <!-- First Blog Card -->
                            <div class="col-md-4 col-12 mb-4">
                                <div class="card blog-card" data-aos="fade-up" data-aos-duration="1000"
                                     data-aos-offset="10">
                                    <div class="position-relative">
                                        <a
                                           href="{{ route('blogs.show', ['slug' => $blog->slug]) }}">
                                            <img
                                                src="{{ $blog->getFirstMediaUrl(app()->getLocale() == 'ar' ? MediaCollection::LIST_BLOG_IMAGE_ARABIC->value : MediaCollection::LIST_BLOG_IMAGE_ENGLISH->value) }}"
                                                class="card-blog-img" alt="Blog Image">
                                        </a>
                                        <span class="custom-badge-blog" data-aos="fade-up" data-aos-duration="1000"
                                              data-aos-offset="10"> {{ getColumn($blog->category, 'name') }}</span>
                                    </div>
                                    <div class="card-body">
                                        <small class="text-muted d-block mb-2" data-aos="fade-up"
                                               data-aos-duration="1000"
                                               data-aos-offset="10">{{ Carbon::create($blog->created_at)->format('F d, Y') }}</small>
                                        <a class="card-blog-title"
                                           href="{{ route('blogs.show', ['slug' => $blog->slug]) }}">
                                            <h5 class="card-blog-title" data-aos="fade-up" data-aos-duration="1000"
                                                data-aos-offset="10"> {{ getColumn($blog, "title") }}</h5>
                                        </a>
                                        <a href="{{ route('blogs.show', ['slug' => $blog->slug]) }}"
                                           class="seedetails-blog" data-aos="fade-up" data-aos-duration="1000"
                                           data-aos-offset="10">  {{ __('lang.see_details') }} <img
                                                src="{{asset('website/assets/images/blog-arrow.svg')}}"
                                                alt="{{ __('lang.details_icon') }}"></a>
                                    </div>

                                </div>
                            </div>
                        @endforeach

                    </div>
                </div>
    </section>


    <!-- Pagination Section -->
    <nav aria-label="Page navigation" class="custom-pagination">
        <ul class="pagination justify-content-center">
            {{$blogs->appends(request()->query())->links("pagination::bootstrap-4")}}
        </ul>
    </nav>
@endsection

@push("scripts")

    <script>
        $(document).ready(function () {
            $('#filterProducts').on('click', function () {
                var selectedCategories = [];
                var allChecked = $('#all').is(':checked');

                // Check if "All" is checked
                if (!allChecked) {
                    // Collect selected categories if "All" is not checked
                    $('.checkbox-custom').each(function () {
                        if ($(this).is(':checked') && $(this).val() !== 'all') {
                            selectedCategories.push($(this).val());
                        }
                    });
                }

                // Build the query string with categories
                var queryString = '';
                if (selectedCategories.length > 0) {
                    queryString = '?categories[]=' + selectedCategories.join('&categories[] =');
                }

                // Redirect to the same page with query parameters
                var currentUrl = window.location.origin + window.location.pathname;
                window.location.href = currentUrl + queryString;
            });
        });

    </script>

@endpush
