@extends('layouts.master')
@section('page-name', $blog->slug)

@section('content')

    <!-- Article Section -->
    <section class="article-section">
        <div class="container-fluid p-200" style="padding-left:250px; padding-right:250px">

            <div class="article-header">
                <h4 class="informational-text" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                    {{ __('lang.category_name', ['name' => getColumn($blog->category, 'name')]) }}</h4>
                <h1 class="making-space-text" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                    {{ __('lang.blog_title', ['title' => getColumn($blog, 'title')]) }}</h1>
                <p class="name-time-text" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                    <img class="name-text-article" src="{{ asset('website/assets/images/user.svg') }}" alt="">
                    {{ __('lang.author', ['author' => getColumn($blog, 'author')]) }}
                    <img class="dot-icon-article" src="{{ asset('website/assets/images/dot-icon.svg') }}" alt="">
                    <img class="time-text-article" src="{{ asset('website/assets/images/time-icon.svg') }}" alt="">
                    {{ \Carbon\Carbon::create($blog->created_at)->format(__('lang.date_format')) }}
                </p>
                <!-- ShareThis BEGIN -->
                <div class="sharethis-inline-share-buttons"></div>
                <!-- ShareThis END -->
            </div>

            <img src="{{ $blog->getFirstMediaUrl(app()->getLocale() == 'ar' ? \App\Enums\Media\MediaCollection::INNER_BLOG_IMAGE_ARABIC->value : \App\Enums\Media\MediaCollection::INNER_BLOG_IMAGE_ENGLISH->value) }}" alt="{{ $blog->slug }}" class="article-image" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">

            <div class="article-body">
                <p data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                    {!! getColumn($blog, 'content') !!}
                </p>
            </div>


            <!-- Blog Vedio Section-->
            <div class="container-fluid p-100">
                <div class="blog-video">

                    @if($blog->video_type == "vimeo")

                            {!! $blog?->video_url !!}

                        @elseif($blog->video_type == "youtube")
                            {!! $blog?->video_url !!}
                        @endif
                    </iframe>
                </div>
            </div>




{{--            <!-- Video Section -->--}}
{{--            <section class="container-fluid p-100">--}}
{{--                <div class="video-section" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">--}}
{{--                    <div class="video-container">--}}
{{--                        <div class="video-overlay-about"--}}
{{--                             style="background-image: url('{{ $blog?->getFirstMediaUrl(\App\Enums\Media\MediaCollection::BLOG_VEDIO_IMAGE->value) }}'); background-size: cover"--}}
{{--                             data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">--}}
{{--                            <div class="play-button" onclick="openVideoModal()">--}}
{{--                                <img src="{{ asset('website/assets/images/vedio-icon.webp') }}" alt="Play Button">--}}
{{--                            </div>--}}
{{--                        </div>--}}
{{--                    </div>--}}
{{--                </div>--}}
{{--            </section>--}}

{{--            <!-- Video Modal -->--}}
{{--            <div id="videoModal" class="modal">--}}
{{--                <div class="modal-content">--}}
{{--                    <span class="close" onclick="closeVideoModal()">&times;</span>--}}
{{--                    <iframe id="videoFrame" src="" frameborder="0" allowfullscreen hidden></iframe>--}}

{{--                    @if($blog->video_type == "vimeo")--}}
{{--                        <div style="position:relative;">--}}
{{--                            {!! $blog?->video_url !!}--}}
{{--                        </div>--}}
{{--                        <script src="https://player.vimeo.com/api/player.js"></script>--}}
{{--                    @elseif($blog->video_type == "youtube")--}}
{{--                        {!! $blog?->youtube_video_url !!}--}}
{{--                    @endif--}}
{{--                </div>--}}
{{--            </div>--}}

            <!-- Suggested Articles -->
            <div class="suggested-articles mt-5">
                <h3 class="suggested-articles-title" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                    {{ __('lang.you_might_like') }}
                </h3>
                <div class="row articles-cards">
                    @foreach($interested_blogs as $interested_blog)
                        <div class="col-md-3 mb-4">
                            <div class="card-article">
                                <img src="{{ $interested_blog->getFirstMediaUrl(app()->getLocale() == 'ar' ? \App\Enums\Media\MediaCollection::BLOG_IMAGE_ARABIC->value : \App\Enums\Media\MediaCollection::BLOG_IMAGE_ENGLISH->value) }}" class="card-img-top" alt="{{ $interested_blog->slug }}" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                <div class="card-body-article">
                                    <h5 class="card-date-article" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                        {{ \Carbon\Carbon::create($interested_blog->created_at)->format(__('lang.date_format')) }}
                                    </h5>
                                    <h3 class="card-title-article" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                        {{ \Illuminate\Support\Str::limit(getColumn($interested_blog, 'title'), 30) }}
                                    </h3>
                                    <!--<p class="card-text-article" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">-->
                                    <!--    {!! \Illuminate\Support\Str::limit(getColumn($interested_blog, 'content'), 80) !!}-->
                                    <!--</p>-->
                                    <a href="{{ route('blogs.show', ['slug' => $interested_blog->slug]) }}" class="seedetails-article" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                        {{ __('lang.see_details') }}
                                    </a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </section>
@endsection

@push("scripts")


            <script>

                const video = document.getElementById('blog-video');
                const playBtn = document.getElementById('play-btn-blog');
                const playIcon = document.getElementById('play-icon');

                playBtn.addEventListener('click', function() {

                    video.src += "&autoplay=1";
                    playIcon.src = "pause-icon.png";
                    playBtn.style.display = 'none';
                });

            </script>
            
    <script src="https://player.vimeo.com/api/player.js"></script>

    <script type='text/javascript' src='https://platform-api.sharethis.com/js/sharethis.js#property=59ecdf1a95f7b200121c2a4d&product=inline-share-buttons' async='async'></script>
@endpush
