<!-- Navbar -->
<nav class="navbar navbar-expand-lg sticky-top">
    <div class="container-fluid p-100">
        <a class="navbar-brand" href="/">
            <img src="{{asset('website/assets/images/kydzoologo.webp')}}" alt="Logo" class="logo-img">
        </a>

        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav"
                aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>

        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav mx-auto ">
                <li class="nav-item">
                    <a class="nav-link" href="/">{{ __('lang.Home') }}</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{{route('about-us')}}">{{ __('lang.About Us') }}</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{{route('courses.index')}}">{{ __('lang.Courses') }}</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{{route('books.index')}}">{{ __('lang.Books') }}</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{{route('events.index')}}">{{ __('lang.Events') }}</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{{route('blogs.index')}}">{{ __('lang.Blog') }}</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{{route('consultation.index')}}">{{ __('lang.Book a consultation') }}</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{{route('contact.form')}}">{{ __('lang.Contact Us') }}</a>
                </li>

                @auth
                    <li class="nav-item nav-mobile">
                        <a class="nav-link" href="{{route('profile.index')}}">{{ __('lang.My Profile') }}</a>
                    </li>

                    <li class="nav-item nav-mobile">
                        <div class="nav-link">
                            <form action="{{ route('logout') }}" method="POST">
                                @csrf
                                <button type="submit" class="logout-btn">
                                    {{ __('lang.Logout') }}
                                </button>
                            </form>
                        </div>
                    </li>
                @else
                    <li class="nav-item nav-mobile">
                        <a class="nav-link" href="{{route('login.show')}}">{{ __('lang.Login') }}</a>
                    </li>

                    <li class="nav-item nav-mobile">
                        <a class="nav-link" href="{{route('register.show')}}">{{ __('lang.signup') }}</a>
                    </li>
                @endif

            </ul>

            <div class="ml-auto d-flex align-items-center">
                <!-- User Icon with Dropdown -->
                <div class="dropdown">
                    <a href="/" class="user-icon" id="userDropdown" role="button" data-bs-toggle="dropdown"
                       aria-expanded="false">
                        <img src="{{asset('website/assets/images/user-icon.svg')}}" alt="User Icon"
                             class="user-icon-img">
                    </a>

                    <!-- Dropdown Menu -->
                    <ul class="dropdown-menu dropdown-menu-end custom-dropdown mt-5" aria-labelledby="userDropdown">
                        @auth
                            <li><a class="dropdown-item" href="{{route("profile.index")}}"><i
                                        class="fas fa-user"></i> {{ __('lang.My Profile') }}</a></li>
                            <li>
                                <form action="{{ route('logout') }}" method="POST" style="display: inline;">
                                    @csrf
                                    <button type="submit" class="dropdown-item">
                                        <i class="fas fa-sign-out-alt"></i> {{ __('lang.Logout') }}
                                    </button>
                                </form>
                            </li>
                        @else
                            <li><a class="dropdown-item" href="{{route('login.show')}}"><i
                                        class="fas fa-sign-in-alt mx-3"></i> {{ __('lang.Login') }}</a></li>
                            <li><a class="dropdown-item" href="{{route('register.show')}}"><i
                                        class="fas fa-sign-in-alt  mx-3"></i> {{ __('lang.signup') }}</a></li>
                        @endif
                    </ul>
                </div>

                <!-- Language Selector -->
                <div class="language-selector">
                    <div class="dropdown">
                        <!-- Button with Current Locale -->
                        <button class="btn btn-secondary dropdown-toggle" type="button" id="languageDropdown"
                                data-bs-toggle="dropdown" aria-expanded="false">
                            {{ LaravelLocalization::getCurrentLocaleNative() }}
                        </button>
                        <ul class="dropdown-menu" aria-labelledby="languageDropdown">
                            @foreach(LaravelLocalization::getSupportedLocales() as $localeCode => $properties)
                                <li>
                                    <a class="dropdown-item" rel="alternate" hreflang="{{ $localeCode }}"
                                       href="{{ LaravelLocalization::getLocalizedURL($localeCode, null, [], true) }}">
                                        {{ $properties['native'] }}
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>

            </div>
        </div>
    </div>
</nav>
