<?php

namespace Database\Seeders;

use App\Enums\Page\Page;
use Illuminate\Database\Seeder;

class PageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $pages = Page::getPages();

        foreach ($pages as $page) {
            \App\Models\Page::query()->updateOrCreate([
                'slug' => $page
            ], [
                'slug' => $page,
                'content_ar' => $page,
                'content_en' => $page,
            ]);
        }

    }
}
