<?php

namespace App\Services\Website\Page;

use App\DTOs\Api\Page\ShowPageDTO;
use App\Repositories\Interfaces\PageRepositoryInterface;
use Exception;

class GetPageService
{
    private ShowPageDTO $dto;
    private ?string $content;

    /**
     * @param PageRepositoryInterface $pageRepository
     */
    public function __construct(
        private readonly PageRepositoryInterface $pageRepository
    ) {
    }

    /**
     * @param ShowPageDTO $dto
     * @return self
     */
    final public function setDto(ShowPageDTO $dto): self
    {
        $this->dto = $dto;
        return $this;
    }

    /**
     * @throws Exception
     */
    final public function execute(): void
    {
        $content = $this->pageRepository->getContentBySlug($this->dto->getPage());

        $this->content = getColumn($content, 'content');
    }

    /**
     * @return string|null
     */
    final public function getContent(): ?string
    {
        return $this->content;
    }
}
