<?php

namespace App\Services\Website\Event;

use App\DTOs\AbstractDTO;
use App\Repositories\Interfaces\EventRepositoryInterface;
use App\Services\BaseService;

class GetInterestedEventsService extends BaseService
{
    private AbstractDTO $dto;
    private string $category_id;

    public function __construct(
        private readonly EventRepositoryInterface $bookRepository
    )
    {
    }

    /**
     * @param string $category_id
     * @return self
     */
    public function setCategoryId(string $category_id): self
    {
        $this->category_id = $category_id;
        return $this;
    }

    public function setDto(AbstractDTO $DTO): static
    {
        $this->dto = $DTO;
        return $this;
    }

    function execute()
    {
        return $this->bookRepository->getInterestedEvents(dto: $this->dto, categoryId: $this->category_id);
    }
}
