<?php

namespace App\Services\Website\Event;

use App\Repositories\Interfaces\BookRepositoryInterface;
use App\Repositories\Interfaces\EventRepositoryInterface;
use App\Services\BaseService;

class GetEventBySlugService extends BaseService
{
    private string $slug;

    public function __construct(
        private readonly EventRepositoryInterface $eventRepository
    )
    {
    }

    /**
     * @param string $slug
     */
    public function setSlug(string $slug): self
    {
        $this->slug = $slug;
        return $this;
    }


    public function execute()
    {
        return $this->eventRepository->getBySlug($this->slug);
    }
}
