<?php

namespace App\Services\Website\Courses;

use App\DTOs\AbstractDTO;
use App\Repositories\Interfaces\CourseRepositoryInterface;
use App\Services\BaseService;

class GetInterestedCoursesService extends BaseService
{
    private AbstractDTO $dto;
    private string $category_id;

    public function __construct(
        private readonly CourseRepositoryInterface $bookRepository
    )
    {
    }

    /**
     * @param string $category_id
     * @return self
     */
    public function setCategoryId(string $category_id): self
    {
        $this->category_id = $category_id;
        return $this;
    }

    public function setDto(AbstractDTO $DTO): static
    {
        $this->dto = $DTO;
        return $this;
    }

    function execute()
    {
        return $this->bookRepository->getInterestedCourses(dto: $this->dto, categoryId: $this->category_id);
    }
}
