<?php

namespace App\Services\Website\Contacts;

use App\DTOs\AbstractDTO;
use App\Repositories\Interfaces\ContactUsRepositoryInterface;

class ContactUsService
{
    private AbstractDTO $dto;

    /**
     * Create a new service instance.
     *
     * @param  ContactUsRepositoryInterface  $contactUsRepository
     * @return void
     */
    public function __construct(private readonly ContactUsRepositoryInterface $contactUsRepository)
    {
    }

    /**
     * Store the contact form submission.
     *
     * @return void
     */
    public function execute(): void
    {
        $this->contactUsRepository->store($this->dto);
    }

    public function setDto(AbstractDTO $dto): static
    {
        $this->dto =$dto;
        return $this;
    }
}
