<?php

namespace App\Services\Website\Book;

use App\DTOs\AbstractDTO;
use App\Repositories\Interfaces\BookRepositoryInterface;
use App\Services\BaseService;

class GetIsFeaturedBooksService extends BaseService
{
    private AbstractDTO $dto;

    public function __construct(
        private readonly BookRepositoryInterface $bookRepository
    )
    {
    }

    public function setDto(AbstractDTO $DTO): static
    {
        $this->dto = $DTO;
        return $this;
    }

    function execute()
    {
        return $this->bookRepository->getIsFeatured($this->dto);
    }
}
