<?php

namespace App\Services\Website\Blog;

use App\DTOs\AbstractDTO;
use App\Repositories\Interfaces\BlogRepositoryInterface;
use App\Services\BaseService;

class GetInterestedBlogsService extends BaseService
{
    private AbstractDTO $dto;
    private string $category_id;

    public function __construct(
        private readonly BlogRepositoryInterface $bookRepository
    )
    {
    }

    /**
     * @param string $category_id
     * @return self
     */
    public function setCategoryId(string $category_id): self
    {
        $this->category_id = $category_id;
        return $this;
    }

    public function setDto(AbstractDTO $DTO): static
    {
        $this->dto = $DTO;
        return $this;
    }

    function execute()
    {
        return $this->bookRepository->getInterestedBlogs(dto: $this->dto, categoryId: $this->category_id);
    }
}
