<?php

namespace App\Services\Website\Announcement;

use App\DTOs\AbstractDTO;
use App\Repositories\Interfaces\AnnouncementRepositoryInterface;
use App\Services\BaseService;

class GetAnnouncementService extends BaseService
{
    private AbstractDTO $dto;

    public function __construct(
        private readonly AnnouncementRepositoryInterface $announcementRepository
    )
    {
    }

    public function setDto(AbstractDTO $DTO): static
    {
        $this->dto = $DTO;
        return $this;
    }

    function execute()
    {
        return $this->announcementRepository->first();
    }
}
