<?php

namespace App\Services\General;

use Hautelook\Phpass\PasswordHash;

class WordPressPasswordService
{
    protected $hasher;

    public function __construct()
    {
        $this->hasher = new PasswordHash(8, true);
    }

    /**
     * Hash a password using WordPress' hashing mechanism.
     *
     * @param string $password
     * @return string
     */
    public function hashPassword($password)
    {
        return $this->hasher->HashPassword($password);
    }

    /**
     * Verify a password against a WordPress hashed password.
     *
     * @param string $password
     * @param string $hashedPassword
     * @return bool
     */
    public function checkPassword($password, $hashedPassword)
    {
        return $this->hasher->CheckPassword($password, $hashedPassword);
    }
}
