<?php

namespace App\Repositories;

use App\DTOs\AbstractDTO;
use App\Models\User;
use App\Repositories\Interfaces\UserRepositoryInterface;
use Illuminate\Database\Eloquent\Model;

class UserRepository extends Repository implements UserRepositoryInterface
{

    public function __construct(User $model)
    {
        $this->setModel($model);
    }

    public function get(AbstractDTO $dto, User $user): ?Model
    {
        return $user;
    }
}

