<?php

namespace App\Repositories;


use App\DTOs\AbstractDTO;
use App\Models\Testimonial;
use App\Repositories\Interfaces\TestimonialRepositoryInterface;
use Illuminate\Database\Eloquent\Collection;

class TestimonialRepository extends Repository implements TestimonialRepositoryInterface
{
    public function __construct(Testimonial $model)
    {
        $this->setModel($model);
    }

    public function get(AbstractDTO $dto): ?Collection
    {
        return $this->getModel()->active()
            ->when($dto->getLimit(), function ($query) use ($dto) {
                $query->limit($dto->getLimit());
            })
            ->orderBy('created_at', 'desc')
            ->get();
    }
}

