<?php

namespace App\Repositories;

use App\Models\Page;
use App\Repositories\Interfaces\PageRepositoryInterface;
use Illuminate\Database\Eloquent\Model;


class PageRepository extends Repository implements PageRepositoryInterface
{

    public function __construct(Page $model)
    {
        $this->setModel($model);
    }

    /**
     * @param string $slug
     * @return string
     */
    final public function getContentBySlug(string $slug): ?Model
    {
        return $this->getModel()->where('slug', $slug)->first();
    }

}
