<?php

namespace App\Repositories;


use App\DTOs\AbstractDTO;
use App\Enums\Category\CategoryTypes;
use App\Models\Announcement;
use App\Models\Category;
use App\Repositories\Interfaces\AnnouncementRepositoryInterface;
use App\Repositories\Interfaces\CategoryRepositoryInterface;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

class CategoryRepository extends Repository implements CategoryRepositoryInterface
{
    public function __construct(Category $model)
    {
        $this->setModel($model);
    }

    public function get(AbstractDTO $dto, string $type): ?Collection
    {
        return $this->getModel()->where('type', $type)->active()->get();
    }
}

