<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Meeting extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'meeting_type',
        'start_time',
        'end_time',
        "response",
        "external_id"
    ];
    
    public function attendees(): HasMany
    {
        return $this->hasMany(Attendee::class);
    }
}
