<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;

class Home extends BaseModel implements HasMedia
{
    use HasFactory;
    use HasUuids;
    use InteractsWithMedia;

    protected $table = "home";

    protected $fillable = [
        'title_ar',
        'title_en',
        'description_ar',
        'description_en',
        'youtube_channel_url',
        'youtube_video_url',
        'status',
        'sort',
        'type',
    ];

    protected $casts = [
        'status' => 'boolean',
        'type' => 'integer',
    ];
}
