<?php

namespace App\Http\Controllers\Website\Webhooks\appointlet;

use App\Http\Controllers\Controller;
use App\Models\Attendee;
use App\Models\Meeting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Carbon\Carbon;

class WebHookController extends Controller
{
    public function handle(Request $request)
    {
        $payload = $request->all();

        Log::info('Webhook ( Appointlet ) payload:', $payload);

        if (isset($payload['entity']['type']) && $payload['entity']['type'] === 'Meeting') {
            if (isset($payload['action']) && $payload['action'] === 'Meeting.scheduled') {
                $this->handleMeetingScheduled($payload);
            }
        }

        return response()->json(['status' => 'Webhook received successfully']);

    }

    private function handleMeetingScheduled($payload)
    {
        $meetingDetails = $payload['entity'];

     
         $meeting = Meeting::updateOrCreate(
        [
            'external_id' => $meetingDetails['id'],
        ],
        [
            'meeting_type' => $meetingDetails['meeting_type']['name'],
            'start_time' => Carbon::parse($meetingDetails['start'])->format('Y-m-d H:i:s') ,
            'end_time' => Carbon::parse( $meetingDetails['end'])->format('Y-m-d H:i:s') ,
            'response' => json_encode($payload),
        ]
    );
    

        foreach ($meetingDetails['attendees'] as $attendeeData) {
        
             Attendee::updateOrCreate(
            [
                'meeting_id' => $meeting->id,
            ],
            [
                'first_name' => $attendeeData['first_name'],
                'last_name' => $attendeeData['last_name'],
                'email' => $attendeeData['email'],
            ]
        );
        
        }
    }
}
