<?php

namespace App\Http\Controllers\Website;

use App\DTOs\Api\Event\GetEventDto;
use App\DTOs\Api\Category\GetCategoryDto;
use App\Enums\Category\CategoryTypes;
use App\Http\Controllers\Controller;
use App\Models\Page;
use App\Services\Website\Event\GetEventBySlugService;
use App\Services\Website\Event\GetInterestedEventsService;
use App\Services\Website\Category\GetCategoriesService;
use App\Services\Website\Event\GetEventService;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Foundation\Application;
use Illuminate\Http\Request;

class EventController extends Controller
{
    public function __construct(
        private readonly GetEventService $getEventService,
        private readonly GetCategoriesService $getCategoriesService,
        private readonly GetEventBySlugService      $getEventBySlugService,
        private readonly GetInterestedEventsService $getInterestedEventsService,
    ){}

    public function index(Request $request): View|Application|Factory|\Illuminate\Contracts\Foundation\Application
    {
        $request->merge(['paginated' => true]);

        $dto = new GetEventDto($request->only('paginated', 'categories'));

        $events = $this->getEventService->setDto($dto)->execute();

        $categoryDto = new GetCategoryDto([]);

        $categories = $this->getCategoriesService->setDto($categoryDto)->setType(CategoryTypes::EVENT->value)->execute();
        $coverDescription = Page::query()->where('slug', \App\Enums\Page\Page::EVENTS_COVER_DESCRIPTION->value)->first();

        return view('website.events', [
            "events" => $events,
            "categories" => $categories,
            "coverDescription" => $coverDescription,
        ]);
    }

    public function show(Request $request, string $slug): View|\Illuminate\Foundation\Application|Factory|\Illuminate\Contracts\Foundation\Application
    {
        $dto = new GetEventDto($request->all());
        $event = $this->getEventBySlugService->setSlug($slug)->execute();

        $interested_events = $this->getInterestedEventsService->setDto($dto)->setCategoryId($event->category_id)->execute();

        return view('website.events-show', [
            "event" => $event,
            "interested_events" => $interested_events,
        ]);
    }
}
