<?php

namespace App\Http\Controllers\Website;

use App\DTOs\Api\ContactUs\ContactUsDTO;
use App\Http\Controllers\Controller;
use App\Services\Website\Contacts\ContactInfoService;
use App\Services\Website\Contacts\ContactUsService;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\View\View;

class ContactController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @param ContactInfoService $contactInfoService
     * @param ContactUsService $contactUsService
     */
    public function __construct(private readonly ContactInfoService $contactInfoService,
                                private readonly ContactUsService   $contactUsService)
    {
    }

    /**
     * Show the contact form.
     *
     * @return View
     */
    public function showForm()
    {
        $contactInfo = $this->contactInfoService->getContactInfo();

        return view('website.contact-us', [
            'contactInfo' => $contactInfo
        ]);
    }

    /**
     * Handle the contact form submission.
     *
     * @param Request $request
     * @return RedirectResponse
     */
    public function send(Request $request): RedirectResponse
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'subject' => 'required|string|max:255',
            'message' => 'required|string',
        ]);

        $dto = new ContactUsDTO($request->only(['name', 'email', 'subject', 'message']));
        $this->contactUsService->setDto($dto)->execute();
        toast( __('lang.message_sent'),'success')->autoClose(9000);

        return redirect()->back();
    }
}
