<?php

namespace App\Filament\Resources;

use App\Filament\Resources\PageResource\Pages;
use App\Filament\Resources\PageResource\RelationManagers;
use App\Models\Page;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;


class PageResource extends Resource
{
    protected static ?string $model = Page::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';
    protected static ?string $navigationGroup = 'Pages';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Select::make('slug')
                    ->label('type')
                    ->options(\App\Enums\Page\Page::getPages())
                    ->reactive()
                    ->required(),

                Forms\Components\Section::make()->schema([

                    Forms\Components\RichEditor::make('content_ar')
                        ->label('Content (Arabic)')
                        ->required()
                        ->columnSpanFull(),
                    Forms\Components\RichEditor::make('content_en')
                        ->label('Content (English)')
                        ->required()
                        ->columnSpanFull(),

                ])->hidden(fn($get) => !in_array($get('slug'), [\App\Enums\Page\Page::PRIVACY_POLICY->value, \App\Enums\Page\Page::TERMS_OF_USE->value])),


                Forms\Components\Section::make()->schema([

                    Forms\Components\RichEditor::make('content_ar')
                        ->label('Cover description (Arabic)')
                        ->required()
                        ->columnSpanFull(),
                    Forms\Components\RichEditor::make('content_en')
                        ->label('Cover description (English)')
                        ->required()
                        ->columnSpanFull(),
                ])->hidden(fn($get) => in_array($get('slug'),[\App\Enums\Page\Page::PRIVACY_POLICY->value, \App\Enums\Page\Page::TERMS_OF_USE->value, \App\Enums\Page\Page::ABOUT_US_COVER_DESCRIPTION])),
            ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListPages::route('/'),
            'create' => Pages\CreatePage::route('/create'),
            'edit' => Pages\EditPage::route('/{record}/edit'),
        ];
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([

                Tables\Columns\TextColumn::make('slug')
                    ->formatStateUsing(function (TextColumn $column): ?string {
                        return str_replace('-', ' ', $column->getRecord()->slug);
                    })
                    ->label('Type')
                    ->sortable(),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function canCreate(): bool
    {
        return false;
    }

    public static function canDeleteAny(): bool
    {
        return false;
    }
}
