<?php

namespace App\Filament\Resources;

use App\Enums\Media\MediaCollection;
use App\Filament\Resources\AnnouncementResource\Pages;
use App\Filament\Resources\AnnouncementResource\RelationManagers;
use App\Models\Announcement;
use Filament\Forms;
use Filament\Forms\Components\SpatieMediaLibraryFileUpload;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

class AnnouncementResource extends Resource
{
    protected static ?string $model = Announcement::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';
    protected static ?string $navigationGroup = 'Home';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Select::make('type')
                    ->options(\App\Enums\Announcement\Announcement::getAnnouncementTypes())
                    ->required(),
                Forms\Components\TextInput::make('title_ar')
                    ->label('Title (Arabic)')
                    ->required()
                    ->maxLength(500)
                    ->columnSpanFull(),
                Forms\Components\TextInput::make('title_en')
                    ->label('Title (English)')
                    ->required()
                    ->maxLength(500)
                    ->columnSpanFull(),
                Forms\Components\TextInput::make('description_ar')
                    ->label('Description (Arabic)')
                    ->required()
                    ->columnSpanFull(),
                Forms\Components\TextInput::make('description_en')
                    ->label('Description (English)')
                    ->required()
                    ->columnSpanFull(),

                Forms\Components\TextInput::make('announcement_url')
                    ->label('Announcement url')
                    ->url()
                    ->required()
                    ->columnSpanFull(),
                Forms\Components\Toggle::make('status')
                    ->required(),

                SpatieMediaLibraryFileUpload::make('image_announcement_arabic')
                    ->label('Image (Arabic)')
                    ->required()
                    ->collection(MediaCollection::ANNOUNCEMENT_IMAGE_ARABIC->value)
                    ->columnSpanFull(),

                SpatieMediaLibraryFileUpload::make('image_announcement_english')
                    ->label('Image (English)')
                    ->required()
                    ->collection(MediaCollection::ANNOUNCEMENT_IMAGE_ENGLISH->value)
                    ->columnSpanFull(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('title_en')
                    ->sortable(),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListAnnouncements::route('/'),
            'create' => Pages\CreateAnnouncement::route('/create'),
            'edit' => Pages\EditAnnouncement::route('/{record}/edit'),
        ];
    }

    public static function canCreate(): bool
    {
        return !Announcement::count();
    }
}
