<?php

namespace App\Filament\Resources;

use App\Enums\About\AboutUsTypes;
use App\Enums\Media\MediaCollection;
use App\Filament\Resources\AboutUsResource\Pages;
use App\Filament\Resources\AboutUsResource\RelationManagers;
use App\Models\AboutUs;
use Filament\Forms;
use Filament\Forms\Components\SpatieMediaLibraryFileUpload;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class AboutUsResource extends Resource
{
    protected static ?string $model = AboutUs::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';
    protected static ?string $navigationGroup = 'Pages';
    protected static ?string $navigationLabel = 'About us';
    protected static ?string $breadcrumb = 'About us';
    protected static ?string $pluralLabel = 'About us';


    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Select::make('type')
                    ->options(AboutUsTypes::getAboutUsTypes())
                    ->reactive()
                    ->required(),
                Forms\Components\TextInput::make('title_ar')
                    ->label( fn($get) => in_array($get('type'), [AboutUsTypes::SLOGAN->value]) ? 'Doctor name & title (Arabic)' : 'Title (Arabic)')
                    ->required()
                    ->hidden(fn($get) => in_array($get('type'), [AboutUsTypes::YOU_TUBE->value]))
                    ->columnSpanFull(),
                Forms\Components\TextInput::make('title_en')
                    ->label( fn($get) => in_array($get('type'), [AboutUsTypes::SLOGAN->value]) ? 'Doctor name & title (English)' :  'Title (English)')
                    ->required()
                    ->hidden(fn($get) => in_array($get('type'), [AboutUsTypes::YOU_TUBE->value]))
                    ->columnSpanFull(),
                Forms\Components\RichEditor::make('description_ar')
                    ->label('Description (Arabic)')
                    ->required()
                    ->hidden(fn($get) => $get('type') == AboutUsTypes::YOU_TUBE->value)
                    ->columnSpanFull(),
                Forms\Components\RichEditor::make('description_en')
                    ->label('Description (English)')
                    ->required()
                    ->hidden(fn($get) => $get('type') == AboutUsTypes::YOU_TUBE->value)
                    ->columnSpanFull(),
                Forms\Components\TextInput::make('youtube_channel_url')
                    ->required()
                    ->url()
                    ->maxLength(65535)
                    ->hidden(fn($get) => $get('type') != AboutUsTypes::YOU_TUBE->value)
                    ->columnSpanFull(),
                Forms\Components\TextInput::make('youtube_video_url')
                    ->required()
                    ->maxLength(65535)
                    ->hidden(fn($get) => $get('type') != AboutUsTypes::YOU_TUBE->value)
                    ->columnSpanFull(),


                SpatieMediaLibraryFileUpload::make('image')
                    ->label('Image')
                    ->collection(MediaCollection::ABOUT_US->value)
                    ->hidden(fn($get) => $get('type') == AboutUsTypes::SLOGAN->value)

                    ->columnSpanFull(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('type')
                    ->formatStateUsing(function (TextColumn $column): ?string {
                        return AboutUsTypes::getAboutUsType($column->getRecord()->type);
                    })
                    ->label('Type')
                    ->sortable(),

                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListAboutUs::route('/'),
            'create' => Pages\CreateAboutUs::route('/create'),
            'edit' => Pages\EditAboutUs::route('/{record}/edit'),
        ];
    }

    public static function canCreate(): bool
    {
        return false;
    }

    public static function canDeleteAny(): bool
    {
        return false;
    }
}
