<?php

namespace App\Enums\Media;

use App\Models\Book;
use App\Models\Course;
use App\Models\Event;

enum MediaCollection: string
{
    // courses images
    case HOME_COURSE_IMAGE_ENGLISH = "home_course_image_english";
    case HOME_COURSE_IMAGE_ARABIC = "home_course_image_arabic";
    case LIST_COURSE_IMAGE_ENGLISH = "list_course_image_english";
    case LIST_COURSE_IMAGE_ARABIC = "list_course_image_arabic";
    case INNER_COURSE_IMAGE_ENGLISH = "inner_course_image_english";
    case INNER_COURSE_IMAGE_ARABIC = "inner_course_image_arabic";

    // blog images
    case BLOG_IMAGE_ENGLISH = "blog_image_english";
    case BLOG_IMAGE_ARABIC = "blog_image_arabic";
    case LIST_BLOG_IMAGE_ENGLISH = "list_blog_image_english";
    case LIST_BLOG_IMAGE_ARABIC = "list_blog_image_arabic";
    case INNER_BLOG_IMAGE_ENGLISH = "inner_blog_image_english";
    case INNER_BLOG_IMAGE_ARABIC = "inner_blog_image_arabic";

    case BLOG_VIDEO_IMAGE = "blog_video_image";

    case COURSE_FILE = "course_file";
    case COURSE_INSTRUCTOR_IMAGE = "course_instructor_image";
    case BOOK_IMAGE_ENGLISH = "book_image_english";
    case BOOK_IMAGE_ARABIC = "book_image_arabic";
    case BOOK_FILE = "book_file";
    case BOOK_SECTION_ONE_IMAGE = "book_section_one_image";
    case BOOK_SECTION_TWO_IMAGE = "book_section_two_image";
    case BOOK_SECTION_THREE_IMAGE = "book_section_three_image";

    case EVENT_IMAGE = "event_image";
    case EVENT_SECTION_ONE_IMAGE = "event_section_one_image";
    case EVENT_SECTION_TWO_IMAGE = "event_section_two_image";
    case EVENT_SECTION_THREE_IMAGE = "event_section_three_image";

    case BRAND_IMAGE = "brand_image";

    case TESTIMONIAL_IMAGE = "Testimonial_image";

    case ANNOUNCEMENT_IMAGE_ARABIC = "announcement_image_arabic";
    case ANNOUNCEMENT_IMAGE_ENGLISH = "announcement_image_english";

    case ABOUT_US = "about_us";
    case HOME = "home";

    case SLOGAN_HOME_IMAGE_ENGLISH = "slogan_home_image_english";
    case SLOGAN_HOME_IMAGE_ARABIC = "slogan_home_image_arabic";



    public static function getImageByProductType($type): string
    {
        return match ($type){
            get_class(new Course()) => app()->getLocale() == 'ar' ? self::HOME_COURSE_IMAGE_ARABIC->value : self::HOME_COURSE_IMAGE_ENGLISH->value,
            get_class(new Event()) => self::EVENT_IMAGE->value,
            get_class(new Book()) => self::EVENT_IMAGE->value,
            null => self::HOME_COURSE_IMAGE_ARABIC->value,
        };
    }


}


