<?php

namespace App\DTOs\Api\Page;


use App\DTOs\AbstractDTO;

class ShowPageDTO extends AbstractDTO
{
    private string $page;

    /**
     * @return string
     */
    final public function getPage(): string
    {
        return $this->page;
    }

    /**
     * @param string $page
     */
    final public function setPage(string $page): void
    {
        $this->page = $page;
    }

    final protected function map(array $data): bool
    {
        $this->page = $data['page'];
        return true;
    }

    /**
     * @return array
     */
    final public function toArray(): array
    {
        return [
            'page' => $this->page,
        ];
    }
}
