<?php

namespace App\DTOs\Api\Book;

use App\DTOs\AbstractDTO;

class GetBookDto extends AbstractDTO
{
    private ?array $categories;
    private ?string $slug;

    /**
     * @return array
     */
    final public function toArray(): array
    {
        return [];
    }

    /**
     * @return array|null
     */
    public function getCategories(): ?array
    {
        return $this->categories;
    }

    /**
     * @return string|null
     */
    public function getSlug(): ?string
    {
        return $this->slug;
    }

    final protected function map(array $data): bool
    {
        $this->categories = isset($data['categories']) ? $data['categories'] : null;
        $this->slug = isset($data['slug']) ? $data['slug'] : null;
        return true;
    }


}
