<?php

namespace App\DTOs\Api\Blog;

use App\DTOs\AbstractDTO;

class GetBlogDto extends AbstractDTO
{
    private ?string $search;
    private ?string $slug;
    private ?array $categories;


    /**
     * @return array
     */
    final public function toArray(): array
    {
        return [];
    }

    /**
     * @return string|null
     */
    public function getSearch(): ?string
    {
        return $this->search;
    }

    /**
     * @return string|null
     */
    public function getSlug(): ?string
    {
        return $this->slug;
    }

    /**
     * @return array|null
     */
    public function getCategories(): ?array
    {
        return $this->categories;
    }

    final protected function map(array $data): bool
    {
        $this->search = isset($data['search']) ? $data['search'] : null;
        $this->slug = isset($data['slug']) ? $data['slug'] : null;
        $this->categories = isset($data['categories']) ? $data['categories'] : null;

        return true;
    }


}
